unit GMP_Cutdown;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, GMP3DAPI, DsgnIntf;

  Type GLBitfield = word;

TColor4 = record
        r,g,b,a : Single;
end;

TPos4 = record
      x,y,z,w : single;
end;

TPoint3D = record
         X : Single;
         Y : Single;
         Z : Single;
end;



TMaterial = record
          Name : String[30];
          Specular  : TColor4;
          Shininess : Single; {0..128}
          Diffuse   : TColor4;
          Ambient   : TColor4;
          Emitted  : TColor4;
end;

TMaterialArray = record
     GMPMaterials : array [0..9] of TMaterial;
end;

TVertex = Class(TObject)
Public
      Point1, Point2, Point3 : Single;
End;

TGMPMaterial = Class(TObject)
Public
	MaterialList : TMaterialArray;
        namething : String;
	Procedure SetRecord( var Rec : TMaterialArray );
	Procedure GetRecord( var Rec : TMaterialArray );
End;


TLight = record
       Number : Integer;
       Enabled : Boolean;
       Diffuse   : TColor4;
       Ambient   : TColor4;
       Specular  : TColor4;
       Position  : TPos4;

end;

type
  TGMPCutdown = class(TComponent)
  private
    { Private declarations }
    MyHDC : HDC;
    MyHGC : HGLRC;
    pfd : TPIXELFORMATDESCRIPTOR;
    PixelFormat : Integer;
    Lights : array [0..7] of TLight;
    FBackR, FBackG, FBackB : Single;
    FFlush : Boolean;
    FShadeEnabled : Boolean;
    F3DRunning : Boolean;
    procedure SetBackR(BackR : Single);
    procedure SetBackG(BackG : Single);
    procedure SetBackB(BackB : Single);
    procedure SetSwapBuffer(SwapIt : BOOLEAN);
    procedure Initialise3D(Running : Boolean);

  protected
    { Protected declarations }
  public
    { Public declarations }
    StripeImage : array [0..95] of byte;
    MyLeft, MyWidth, MyHeight, MyBottom, PolygonCount : Integer;
    RGBImage1 : PAUX_RGBImageRec;
    RGBImage2 : PAUX_RGBImageRec;
    RGBImage3 : PAUX_RGBImageRec;
    RGBImage4 : PAUX_RGBImageRec;
    RGBImage5 : PAUX_RGBImageRec;
    RGBImage6 : PAUX_RGBImageRec;
    RGBImage7 : PAUX_RGBImageRec;
    RGBImage8 : PAUX_RGBImageRec;
    RGBImage9 : PAUX_RGBImageRec;
    RGBImage10 : PAUX_RGBImageRec;
    GMPGold : TMaterial;
    GMPSilver : TMaterial;
    GMPPewter : TMaterial;
    GMPChalk : TMaterial;
    GMPEbony : TMaterial;
    GMPWoodBrown : TMaterial;
    GMPBluePlastic : TMaterial;
    GMPShinyBrass : TMaterial;
    GMPBlackRubber : TMaterial;
    GMPEmerald : TMaterial;
    GMPLightBrown : TMaterial;
    GMPDarkGreen : TMaterial;
    GMPRuby : Tmaterial;
    Ambient_Default : TColor4;
    Diffuse_Default : TColor4;
    Specular_Default : TColor4;
    Mat_Ambient : TColor4;
    Mat_Diffuse : TColor4;
    Mat_Emission : TColor4;
    Mat_Shininess : Single;
    Mat_Specular : TColor4;
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure SwapBackBuffer;
    procedure CalcNormal(var P1, P2, P3, Normal1 : TPoint3D);
    procedure SetViewPort(left, bottom, width, height : Integer);
    procedure ClearBuffer;
    procedure ClearModelMatrix;
    procedure SetRotation(X,Y,Z,Angle : Single);
    procedure SetPosition(X,Y,Z : Single);
    procedure SetScale(X,Y,Z : Single);
    procedure SetLight(Enabled : Boolean; var Position : TPos4; var Ambient, Diffuse, Specular : TColor4);
    procedure SetBuiltInMaterial(Name : String);
    procedure SetCurrentTexture1(filename : String; OnOrOff : Boolean);
    procedure SetCurrentTexture2(filename : String; OnOrOff : Boolean);
    procedure SetCurrentTexture3(filename : String; OnOrOff : Boolean);
    procedure SetCurrentTexture4(filename : String; OnOrOff : Boolean);
    procedure SetCurrentTexture5(filename : String; OnOrOff : Boolean);
    procedure SetCurrentTexture6(filename : String; OnOrOff : Boolean);
    procedure Load_Compile_RawObject(filename : String; Number : Integer; Double_Sided : Boolean);
    procedure Load_Compile_GEOObject(filename : String; Number : Integer; Double_Sided : Boolean);
    procedure DrawCompiledRawObject(Number : Integer);
    procedure DrawCompiledGEOObject(Number : Integer);
    procedure SetCamera(var Position, Rotation : TPoint3D);
    procedure EnableFogging(YesNo : Boolean; TheStart, TheEnd : Single);
    procedure GMPSphere(size : Double);
    procedure GMPCube(size : Double);
    procedure GMPOct(size : Double);
    procedure GMPTet(size : Double);
    procedure GMPDod(size : Double);
    procedure GMPIcos(size : Double);
    procedure GMPTorus(width, circ : Double);
    procedure GMPCone(width, height : Double);
    procedure GMPCylinder(width, height : Double);
    procedure GMPSmooth(Choice : Boolean);
    procedure GMPBox(Width, height, depth : double);
    procedure GMPLoadAutoTexture(name : String; enable : boolean);
    procedure GMPShadedTriangle(var Vertex  : array of TPoint3D);
    procedure GMPShadedSquare(var Vertex, Normal : array of single);
    procedure GMPTexturedSquare(var Vertex, Normal, TexCoord : array of single);
    procedure GMPTexturedTriangle(var Vertex, Text : array of TPoint3D);
  published
    { Published declarations }
    property Back_Red : Single read FBackR write SetBackR;
    property Back_Green : Single read FBackG write SetBackG;
    property Back_Blue : Single read FBackB write SetBackB;
    property SwapTheBuffer : Boolean read FFlush write SetSwapBuffer;
    property Start3D : Boolean read F3DRunning write Initialise3D;

  end;

procedure Register;

implementation

procedure TGMPCutdown.SetCurrentTexture1(filename : String; OnOrOff : Boolean);
const
     TheName1 : String = 'Testinf Testing';
var
   sgenparams : array [0..3] of single;
begin

     If OnOrOff = false then
     begin
          gldisable(GL_TEXTURE_2D);
          exit;
     end;

     If TheName1 = filename then
     begin
          glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
          glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
          glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
          glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
          glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_nearest);
          glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_nearest);
          glTexImage2D(GL_TEXTURE_2D, 0,3,RGBImage1^.sizeX, RGBImage1^.sizey, 0,GL_RGB, GL_UNSIGNED_BYTE, RGBImage1^.Data);
          glEnable(GL_TEXTURE_2D);
          exit;
     end;
     TheName1 := filename;



     sgenparams[0] := 1;
     sgenparams[1] := 0;
     sgenparams[2] := 0;
     sgenparams[3] := 0;
     RGBImage1 := LoadBMP(pChar(filename));
     If RGBImage1^.data = nil then showmessage('Neeee');
     glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
     glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_nearest);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_nearest);
     glTexImage2D(GL_TEXTURE_2D, 0,3,RGBImage1^.sizeX, RGBImage1^.sizey, 0,GL_RGB, GL_UNSIGNED_BYTE, RGBImage1^.Data);
     glEnable(GL_TEXTURE_2D);

end;

procedure TGMPCutdown.SetCurrentTexture2(filename : String; OnOrOff : Boolean);
const
     TheName2 : String = 'Testinf Testing';
var
   sgenparams : array [0..3] of single;
begin

     If OnOrOff = false then
     begin
          gldisable(GL_TEXTURE_2D);
          exit;
     end;

     If TheName2 = filename then
     begin
     glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
     glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_nearest);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_nearest);
     glTexImage2D(GL_TEXTURE_2D, 0,3,RGBImage2^.sizeX, RGBImage2^.sizey, 0,GL_RGB, GL_UNSIGNED_BYTE, RGBImage2^.Data);
          glEnable(GL_TEXTURE_2D);
          exit;
     end;
     TheName2 := filename;



     sgenparams[0] := 1;
     sgenparams[1] := 0;
     sgenparams[2] := 0;
     sgenparams[3] := 0;
     RGBImage2 := LoadBMP(pChar(filename));
     If RGBImage2^.data = nil then showmessage('Neeee');
     glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
     glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_nearest);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_nearest);
     glTexImage2D(GL_TEXTURE_2D, 0,3,RGBImage2^.sizeX, RGBImage2^.sizey, 0,GL_RGB, GL_UNSIGNED_BYTE, RGBImage2^.Data);
     glEnable(GL_TEXTURE_2D);

end;


procedure TGMPCutdown.SetCurrentTexture3(filename : String; OnOrOff : Boolean);
const
     TheName : String = 'Testinf Testing';
var
   sgenparams : array [0..3] of single;
begin

     If OnOrOff = false then
     begin
          gldisable(GL_TEXTURE_2D);
          exit;
     end;

     If TheName = filename then
     begin
     glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
     glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_nearest);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_nearest);
     glTexImage2D(GL_TEXTURE_2D, 0,3,RGBImage3^.sizeX, RGBImage3^.sizey, 0,GL_RGB, GL_UNSIGNED_BYTE, RGBImage3^.Data);
          glEnable(GL_TEXTURE_2D);
          exit;
     end;
     TheName := filename;



     sgenparams[0] := 1;
     sgenparams[1] := 0;
     sgenparams[2] := 0;
     sgenparams[3] := 0;
     RGBImage3 := LoadBMP(pChar(filename));
     If RGBImage3^.data = nil then showmessage('Neeee');
     glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
     glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_nearest);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_nearest);
     glTexImage2D(GL_TEXTURE_2D, 0,3,RGBImage3^.sizeX, RGBImage3^.sizey, 0,GL_RGB, GL_UNSIGNED_BYTE, RGBImage3^.Data);
     glEnable(GL_TEXTURE_2D);

end;


procedure TGMPCutdown.SetCurrentTexture4(filename : String; OnOrOff : Boolean);
const
     TheName : String = 'Testinf Testing';
var
   sgenparams : array [0..3] of single;
begin

     If OnOrOff = false then
     begin
          gldisable(GL_TEXTURE_2D);
          exit;
     end;

     If TheName = filename then
     begin
     glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
     glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_nearest);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_nearest);
     glTexImage2D(GL_TEXTURE_2D, 0,3,RGBImage4^.sizeX, RGBImage4^.sizey, 0,GL_RGB, GL_UNSIGNED_BYTE, RGBImage4^.Data);
          glEnable(GL_TEXTURE_2D);
          exit;
     end;
     TheName := filename;



     sgenparams[0] := 1;
     sgenparams[1] := 0;
     sgenparams[2] := 0;
     sgenparams[3] := 0;
     RGBImage4 := LoadBMP(pChar(filename));
     If RGBImage4^.data = nil then showmessage('Neeee');
     glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
     glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_nearest);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_nearest);
     glTexImage2D(GL_TEXTURE_2D, 0,3,RGBImage4^.sizeX, RGBImage4^.sizey, 0,GL_RGB, GL_UNSIGNED_BYTE, RGBImage4^.Data);
     glEnable(GL_TEXTURE_2D);

end;


procedure TGMPCutdown.SetCurrentTexture5(filename : String; OnOrOff : Boolean);
const
     TheName : String = 'Testinf Testing';
var
   sgenparams : array [0..3] of single;
begin

     If OnOrOff = false then
     begin
          gldisable(GL_TEXTURE_2D);
          exit;
     end;

     If TheName = filename then
     begin
     glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
     glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_nearest);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_nearest);
     glTexImage2D(GL_TEXTURE_2D, 0,3,RGBImage5^.sizeX, RGBImage5^.sizey, 0,GL_RGB, GL_UNSIGNED_BYTE, RGBImage5^.Data);
          glEnable(GL_TEXTURE_2D);
          exit;
     end;
     TheName := filename;



     sgenparams[0] := 1;
     sgenparams[1] := 0;
     sgenparams[2] := 0;
     sgenparams[3] := 0;
     RGBImage5 := LoadBMP(pChar(filename));
     If RGBImage5^.data = nil then showmessage('Neeee');
     glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
     glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_nearest);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_nearest);
     glTexImage2D(GL_TEXTURE_2D, 0,3,RGBImage5^.sizeX, RGBImage5^.sizey, 0,GL_RGB, GL_UNSIGNED_BYTE, RGBImage5^.Data);
     glEnable(GL_TEXTURE_2D);

end;

procedure TGMPCutdown.SetCurrentTexture6(filename : String; OnOrOff : Boolean);
const
     TheName : String = 'Testinf Testing';
var
   sgenparams : array [0..3] of single;
begin

     If OnOrOff = false then
     begin
          gldisable(GL_TEXTURE_2D);
          exit;
     end;

     If TheName = filename then
     begin
     glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
     glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_nearest);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_nearest);
     glTexImage2D(GL_TEXTURE_2D, 0,3,RGBImage6^.sizeX, RGBImage6^.sizey, 0,GL_RGB, GL_UNSIGNED_BYTE, RGBImage6^.Data);
          glEnable(GL_TEXTURE_2D);
          exit;
     end;
     TheName := filename;



     sgenparams[0] := 1;
     sgenparams[1] := 0;
     sgenparams[2] := 0;
     sgenparams[3] := 0;
     RGBImage6 := LoadBMP(pChar(filename));
     If RGBImage6^.data = nil then showmessage('Neeee');
     glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
     glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_nearest);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_nearest);
     glTexImage2D(GL_TEXTURE_2D, 0,3,RGBImage6^.sizeX, RGBImage6^.sizey, 0,GL_RGB, GL_UNSIGNED_BYTE, RGBImage6^.Data);
     glEnable(GL_TEXTURE_2D);

end;
procedure TGMPCutdown.GMPShadedTriangle(var Vertex  : array of TPoint3D);
var
   normal : TPoint3D;
begin
     CalcNormal(Vertex[0], Vertex[1], Vertex[2], Normal);
      glBegin(GL_Triangles);
     glNormal3f(Normal.X, Normal.Y, Normal.Z);
     glVertex3f(Vertex[0].X, Vertex[0].Y, Vertex[0].Z);

     glNormal3f(Normal.X, Normal.Y, Normal.Z);
     glVertex3f(Vertex[1].X, Vertex[1].Y, Vertex[1].Z);

     glNormal3f(Normal.X, Normal.Y, Normal.Z);
     glVertex3f(Vertex[2].X, Vertex[2].Y, Vertex[2].Z);

     glEnd;

end;
procedure TGMPCutdown.GMPShadedSquare(var Vertex, Normal : array of single);
begin
end;
procedure TGMPCutdown.GMPTexturedSquare(var Vertex, Normal, TexCoord : array of single);
begin
end;
procedure TGMPCutdown.GMPTexturedTriangle(var Vertex, Text : array of TPoint3D);
var
   normal : TPoint3D;
begin
     glBegin(GL_Triangles);
     CalcNormal(Vertex[0], Vertex[1], Vertex[2], Normal);

     glTexCoord2f(Text[0].X,Text[0].Y);
     glNormal3f(Normal.X, Normal.Y, Normal.Z);
     glVertex3f(Vertex[0].X, Vertex[0].Y, Vertex[0].Z);

     glTexCoord2f(Text[1].X,Text[1].Y);
     glVertex3f(Vertex[1].X, Vertex[1].Y, Vertex[1].Z);

     glTexCoord2f(Text[2].X,Text[2].Y);
     glVertex3f(Vertex[2].X, Vertex[2].Y, Vertex[2].Z);

     glEnd;

end;

procedure TGMPCutdown.GMPBox(Width, height, depth : double);
begin
    Box(Width, height, depth );
end;


procedure TGMPMaterial.SetRecord(var Rec : TMaterialArray);
begin
          MaterialList := Rec;
end;

procedure TGMPMaterial.GetRecord(var Rec : TmaterialArray);
begin
          Rec := MaterialList;
end;

procedure TGMPCutdown.GMPLoadAutoTexture(name : String; enable : boolean);
const
   done : boolean = false;
   current : String = 'Testing Testing';
var
   sgenparams : array [0..3] of single;

begin

     If enable = false then
     begin
          gldisable(GL_TEXTURE_GEN_s);
          gldisable(GL_TEXTURE_GEN_t);
          gldisable(GL_TEXTURE_2D);
          exit;
     end;
     If current = name then
     begin
          glenable(GL_TEXTURE_GEN_s);
          glenable(GL_TEXTURE_GEN_t);
          glenable(GL_TEXTURE_2D);
     exit;
     end;
     sgenparams[0] := 1;
     sgenparams[1] := 0;
     sgenparams[2] := 0;
     sgenparams[3] := 0;
     RGBImage1 := LoadBMP(pChar(name));
     If RGBImage1^.data = nil then showmessage('Neeee');
     glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
     glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_nearest);
     glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_nearest);
     glTexImage2D(GL_TEXTURE_2D, 0,3,RGBImage1^.sizeX, RGBImage1^.sizey, 0,GL_RGB, GL_UNSIGNED_BYTE, RGBImage1^.Data);
     glTexGeni(GL_s, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
     glTexGenfv(GL_s, GL_OBJECT_PLANE, @sgenparams);
     glTexGeni(GL_t, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
     glTexGenfv(GL_t, GL_OBJECT_PLANE, @sgenparams);
     glEnable(GL_TEXTURE_GEN_s);
     glEnable(GL_TEXTURE_GEN_t);
     glEnable(GL_TEXTURE_2D);
     done := true;
     current := name;



end;




procedure TGMPCutdown.GMPSmooth(Choice : Boolean);
begin
    If Choice = True then glShadeModel(GL_SMOOTH) else glShadeModel(GL_FLAT);
end;

Procedure TGMPCutdown.SetScale(X,Y,Z : Single);
begin
     glScalef(X,Y,Z);
end;

procedure TGMPCutdown.GMPCylinder(width, height : Double);
begin
     DrawCylinder(width, height);
end;

procedure TGMPCutdown.GMPCone(width, height : Double);
begin
     DrawCone(width, height);
end;

procedure TGMPCutdown.GMPIcos(size : Double);
begin
     DrawIcosahedron(size);
end;


procedure TGMPCutdown.GMPDod(size : Double);
begin
     DrawDodecahedran(size);
end;


procedure TGMPCutdown.GMPTet(size : Double);
begin
     DrawTetrahedron(size);
end;

procedure TGMPCutdown.GMPOct(size : Double);
begin
     DrawOctahedron(size);
end;

procedure TGMPCutdown.GMPTorus(width, circ : Double);
begin
     DrawTorus(width, circ);
end;

procedure TGMPCutdown.GMPSphere(size : Double);
begin
     DrawSphere(size);
end;

procedure TGMPCutdown.GMPCube(size : Double);
begin
     DrawCube(size);
end;

procedure TGMPCutdown.EnableFogging(YesNo : Boolean; TheStart, TheEnd : Single);
var
   FogColor : TColor4;
begin
If YesNo = True then
begin
     glEnable(GL_FOG);
     glFogi(GL_FOG_MODE, GL_LINEAR);
     FogColor.R := 0.6;
     FogColor.G := 0.6;
     FogColor.B := 0.6;
     FogColor.A := 1;
     glFogfv(GL_FOG_COLOR, @fogColor.r);
     glFogf(GL_FOG_END, TheEnd);
     glFogf(GL_FOG_START, TheStart);
     glHint(GL_FOG_HINT, GL_FASTEST);
end
else glDisable(GL_FOG);


end;



procedure TGMPCutdown.SetBuiltInMaterial(Name : String);
var
Material : TMaterial;
begin
     If name = 'Gold' then Material := GMPGold
     else If name = 'Silver' then Material := GMPSilver
     else If name = 'Ebony' then Material := GMPEbony
     else If name = 'ShinyBrass' then Material := GMPShinyBrass
     else If name = 'Pewter' then Material := GMPPewter
     else If name = 'Chalk' then Material := GMPChalk
     else If name = 'BluePlastic' then Material := GMPBluePlastic
     else If name = 'BlackRubber' then Material := GMPBlackRubber
     else If name = 'Emerald' then Material := GMPEmerald
     else If name = 'Ruby' then Material := GMPRuby
     else If name = 'WoodBrown' then Material := GMPWoodBrown
     else If name = 'DarkGreen' then Material := GMPDarkGreen
     else If name = 'LightBrown' then Material := GMPLightBrown
     else exit;

    glMaterialfv(GL_FRONT, GL_AMBIENT, @Material.Ambient);
    glMaterialfv(GL_FRONT, GL_DIFFUSE, @Material.Diffuse);
    glMaterialfv(GL_FRONT, GL_SPECULAR, @Material.Specular);
    glMaterialfv(GL_FRONT, GL_EMISSION, @Material.Emitted);
    glMaterialfv(GL_FRONT, GL_SHININESS, @Material.SHininess);

end;


procedure TGMPCutdown.DrawCompiledRawObject(Number : Integer);
begin
     glCallList(Number);
end;

procedure TGMPCutdown.DrawCompiledGEOObject(Number : Integer);
begin
     glCallList(Number);
end;

PROCEDURE TGMPCutdown.Load_Compile_RawObject(filename : String; Number : Integer; Double_Sided : Boolean );
var
   Line : String;
   p1,p2,p3,n1 : TPoint3D;
   RawFile : System.Text;
   Counter : Integer;
begin
     Counter := 0;
     AssignFile(RawFile, Filename);
     Reset(RawFile);
     glNewList(Number, GL_COMPILE);
     glBegin(GL_TRIANGLES);

     While not EOF(RawFile) do
     begin
          Readln(RawFile, p1.X, p1.Y, P1.Z);
          Readln(RawFile, p2.X, p2.Y, p2.z);
          Readln(RawFile, p3.X, p3.Y, p3.Z);
          CalcNormal(p1,p2,p3,n1);
          glNormal3f(-n1.X,-n1.Y,-n1.Z);
          glTexCoord2f(0.5,0);
          glVertex3f(p3.X, p3.Y, p3.Z);
          glTexCoord2f(0,-1);
          glVertex3f(p2.X, p2.Y, p2.Z);
          glTexCoord2f(1,-1);
          glVertex3f(p1.X, p1.Y, p1.Z);

          If Double_Sided = True then
          begin
               CalcNormal(p3,p2,p1,n1);
               glNormal3f(-n1.X,-n1.Y,-n1.Z);
               glTexCoord2f(0.5,0);
               glVertex3f(p1.X, p1.Y, p1.Z);
               glTexCoord2f(0,-1);
               glVertex3f(p2.X, p2.Y, p2.Z);
               glTexCoord2f(1,-1);
               glVertex3f(p3.X, p3.Y, p3.Z);

          end;
          INC(cOUNTER);

     end;
          glEnd;
     glEndList;
     CloseFile(RawFile);
     PolygonCount := Counter;

end;

PROCEDURE TGMPCutdown.Load_Compile_GEOObject(filename : String; Number : Integer; Double_Sided : Boolean );
var
   Line, Temp : String;
   p1,p2,p3,p4,n1 : TPoint3D;
   GeoFile : System.Text;
   Counter, X,P, Polygons : Integer;
   Point, Start :  ^single;

begin
     Counter := 0;
     AssignFile(GeoFile, Filename);
     Reset(GeoFile);
     ReadLn(GeoFile, Line);
     {ShowMessage(Line);}
     ReadLn(GeoFile, Polygons);
     {ShowMessage(IntToStr(Polygons));}
     ReadLn(GeoFile, P1.X, p1.Y, P1.Z);
     Getmem(Start, 12 * Polygons);
     Point := Start;
     Point^ := P1.X;
     {ShowMessage(FloatToStr(Point^));}
     Inc(Point);
     Point^ := P1.Y;
     {ShowMessage(FloatToStr(Point^));}
     Inc(Point);
     Point^ := -P1.Z;
     {ShowMessage(FloatToStr(Point^));}
     Inc(Point);
     For X := 1 to Polygons - 1 do
     begin
          ReadLn(GeoFile, P1.X, p1.Y, P1.Z);
          Point^ := P1.X;
     {ShowMessage(FloatToStr(Point^));}
          Inc(Point);
          Point^ := P1.Y;
{     ShowMessage(FloatToStr(Point^));  }
          Inc(Point);
          Point^ := -P1.Z;
 {    ShowMessage(FloatToStr(Point^));}
          Inc(Point);
     End;
     Point := Start;
{     For P := 0 to (Polygons div 3) -1 do
     begin
          ShowMessage(' X := ' + FloatToStr(Point^));
          Inc(Point);
          ShowMessage(' Y := ' + FloatToStr(Point^));
          Inc(Point);
          ShowMessage(' Z := ' + FloatToStr(Point^));
          Inc(Point);

     end;}
     glNewList(Number, GL_COMPILE);

While not EOF(GeoFile) do
begin
     ReadLn(GeoFile, Line);
{     ShowMessage('This is the whole line ' + Line);}
     If Line[1] = '4'  then
     begin
          glBegin(GL_QUADS);

          {Point 1}
          Delete(Line, 1, 2);
          X := Pos(' ', Line);
          Temp := Copy(Line, 1, X-1);
{          ShowMessage('This is the first point number ' + Temp);}
          Point := Start;
          For P := 0 to ((StrToInt(Temp) * 3) - 1) do
          begin
               Inc(Point);
          end;
          p1.X := Point^;
 {         ShowMessage(FloatToStr(Point^));}
          Inc(Point);
          p1.Y := Point^;
{          ShowMessage(FloatToStr(Point^));  }
          Inc(Point);
          P1.Z := Point^;
 {         ShowMessage(FloatToStr(Point^));}
          Delete(Line, 1, X);

          {Point 2}
          X := Pos(' ', Line);
          Temp := Copy(Line, 1, X-1);
{          ShowMessage('This is the scond point number ' + Temp);}
          Point := Start;
          For P := 0 to ((StrToInt(Temp) * 3) - 1) do
          begin
               Inc(Point);
          end;

          p2.X := Point^;
 {         ShowMessage(FloatToStr(Point^));}
          Inc(Point);
          p2.Y := Point^;
{          ShowMessage(FloatToStr(Point^));  }
          Inc(Point);
          P2.Z := Point^;
 {         ShowMessage(FloatToStr(Point^));}
          Delete(Line, 1, X);

          {Point 3}
          X := Pos(' ', Line);
          Temp := Copy(Line, 1, X-1);
{          ShowMessage('This is the third point number ' + Temp);}
          Point := Start;
          For P := 0 to ((StrToInt(Temp) * 3) - 1) do
          begin
               Inc(Point);
          end;
          p3.X := Point^;
 {         ShowMessage(FloatToStr(Point^));}
          Inc(Point);
          p3.Y := Point^;
{          ShowMessage(FloatToStr(Point^));  }
          Inc(Point);
          P3.Z := Point^;
 {         ShowMessage(FloatToStr(Point^));}
          Delete(Line, 1, X);

          {Point 4}
          X := Pos(' ', Line);
          Temp := Copy(Line, 1, X-1);
{          ShowMessage('This is the fourth point number ' + Temp);}
          Point := Start;
          For P := 0 to ((StrToInt(Temp) * 3) - 1) do
          begin
               Inc(Point);
          end;
          p4.X := Point^;
 {         ShowMessage(FloatToStr(Point^));}
          Inc(Point);
          p4.Y := Point^;
{          ShowMessage(FloatToStr(Point^));  }
          Inc(Point);
          P4.Z := Point^;
 {         ShowMessage(FloatToStr(Point^));}

          CalcNormal(p1,p2,p3,n1);
          glNormal3f(-n1.X,-n1.Y,-n1.Z);
          glTexCoord2f(0,0);
          glVertex3f(p4.X, p4.Y, p4.Z);
          glTexCoord2f(-1,0);
          glVertex3f(p3.X, p3.Y, p3.Z);
          glTexCoord2f(-1,-1);
          glVertex3f(p2.X, p2.Y, p2.Z);
          glTexCoord2f(0,-1);
          glVertex3f(p1.X, p1.Y, p1.Z);
          glEnd;

          If Double_Sided = True then
          begin
               glBegin(GL_QUADS);
               CalcNormal(p3,p2,p1,n1);
               glNormal3f(-n1.X,-n1.Y,-n1.Z);
               glTexCoord2f(-1,0);
               glVertex3f(p1.X, p1.Y, p1.Z);
               glTexCoord2f(-1,-1);
               glVertex3f(p2.X, p2.Y, p2.Z);
               glTexCoord2f(0,-1);
               glVertex3f(p3.X, p3.Y, p3.Z);
               glTexCoord2f(0,0);
               glVertex3f(p4.X, p4.Y, p4.Z);
               glEnd;
          end;
      continue;

     end;

     If Line[1] = '3'  then
     begin
          glBegin(GL_TRIANGLES);

          {Point 1}
          Delete(Line, 1, 2);
          X := Pos(' ', Line);
          Temp := Copy(Line, 1, X-1);
          Point := Start;
          For P := 0 to (StrToInt(Temp) * 3) - 1 do
          begin
               Inc(Point);
          end;
          p1.X := Point^;
          Inc(Point);
          p1.Y := Point^;
          Inc(Point);
          P1.Z := Point^;
          Delete(Line, 1, X);

          {Point 2}
          X := Pos(' ', Line);
          Temp := Copy(Line, 1, X-1);
          Point := Start;
          For P := 0 to (StrToInt(Temp) * 3) - 1 do
          begin
               Inc(Point);
          end;

          p2.X := Point^;
          Inc(Point);
          p2.Y := Point^;
          Inc(Point);
          P2.Z := Point^;
          Delete(Line, 1, X);

          {Point 3}
          X := Pos(' ', Line);
          Temp := Copy(Line, 1, X-1);
          Point := Start;
          For P := 0 to (StrToInt(Temp) * 3) - 1 do
          begin
               Inc(Point);
          end;
          p3.X := Point^;
          Inc(Point);
          p3.Y := Point^;
          Inc(Point);
          P3.Z := Point^;

          CalcNormal(p1,p2,p3,n1);
          glNormal3f(-n1.X,-n1.Y,-n1.Z);
          glTexCoord2f(0.5,0);
          glVertex3f(p3.X, p3.Y, p3.Z);
          glTexCoord2f(0,-1);
          glVertex3f(p2.X, p2.Y, p2.Z);
          glTexCoord2f(1,-1);
          glVertex3f(p1.X, p1.Y, p1.Z);
          glEnd;

          If Double_Sided = True then
          begin
               glBegin(GL_TRIANGLES);
               CalcNormal(p3,p2,p1,n1);
               glNormal3f(-n1.X,-n1.Y,-n1.Z);
               glTexCoord2f(0.5,0);
               glVertex3f(p1.X, p1.Y, p1.Z);
               glTexCoord2f(0,-1);
               glVertex3f(p2.X, p2.Y, p2.Z);
               glTexCoord2f(1,-1);
               glVertex3f(p3.X, p3.Y, p3.Z);
               glEnd;

          end;




     end;




     end;
     glEndList;
     CloseFile(GeoFile);
     Freemem(Start, 12*Polygons);

end;


procedure TGMPCutdown.Initialise3D(Running : Boolean);
var
X : Integer;
Position : TPOs4;
Color1 : TMaterial;
begin
    If (F3DRunning = False) and (Running = True) then
    begin
         F3DRunning := True;
         pfd.nsize :=  40;
         pfd.nVersion := 1;
         pfd.dwFlags :=  PFD_DRAW_TO_WINDOW + PFD_SUPPORT_OPENGL + PFD_DOUBLEBUFFER;
         pfd.iPixelType := PFD_TYPE_RGBA;
         pfd.cColorBits := 24; pfd.cRedBits := 0; pfd.cRedShift := 0; pfd.cGreenBits := 0;
         pfd.cGreenShift := 0; pfd.cBlueBits := 0; pfd.cBlueShift := 0; pfd.cAlphaBits := 0;
         pfd.cAlphaShift := 0; pfd.cAccumBits := 0; pfd.cAccumRedBits := 0; pfd.cAccumGreenBits := 0;
         pfd.cAccumBlueBits := 0; pfd.cAccumAlphaBits := 0; pfd.cDepthBits := 32;
         pfd.cStencilBits := 0; pfd.cAuxBuffers := 0; pfd.iLayerType := PFD_MAIN_PLANE;
         pfd.iLayerType := 0;
         pfd.bReserved := 0;
         pfd.dwLayerMask := 0;
         pfd.dwVisiblemask := 0;
         pfd.dwDamageMask := 0;
         pixelFormat := ChoosePixelFormat(MyHDC, @pfd);
         SetPixelFormat(MyHdc, pixelFormat, @pfd);
         DescribePixelFormat(MyHDC, pixelFormat, sizeof(pfd), pfd);
         MyHgc := wglCreateContext(MyHDC);
         wglmakeCurrent(MyHDC, MYHGC);
         SwapBuffers(MyHDC);
         glEnable(GL_DEPTH_TEST);
         For X := 0 to 7 do
         begin
              Lights[X].Number := X;
              Lights[X].enabled := False;
              Lights[X].Position.X := 0;
              Lights[X].Position.Y := 0;
              Lights[X].Position.Z := 0;
              Lights[X].Position.W := 1;
              Lights[X].Ambient.R := 0.8;
              Lights[X].Ambient.G := 0.8;
              Lights[X].Ambient.B := 0.8;
              Lights[X].Ambient.A := 1;
              Lights[X].Diffuse.R := 0.8;
              Lights[X].Diffuse.G := 0.8;
              Lights[X].Diffuse.B := 0.8;
              Lights[X].Diffuse.A := 1;
              Lights[X].Specular.R := 1;
              Lights[X].Specular.G := 1;
              Lights[X].Specular.B := 1;
              Lights[X].Specular.A := 1;
         end;
         Ambient_Default := Lights[0].Ambient;
         Diffuse_Default := Lights[0].Diffuse;
         Specular_Default := Lights[0].Specular;
         Mat_Ambient.r := 0.2;
         Mat_Ambient.g := 0.2;
         Mat_Ambient.b := 0.2;
         Mat_Ambient.a := 1.0;
         Mat_Diffuse.r := 0.8;
         Mat_Diffuse.g := 0.8;
         Mat_Diffuse.b := 0.8;
         Mat_Diffuse.a := 1;
         Mat_Specular := Ambient_Default;
         Mat_Shininess := 0;
         Mat_Emission := Ambient_Default;
         glEnable(GL_LIGHTING);
         glShadeModel(GL_SMOOTH);
         glPolygonMode(GL_FRONT, GL_FILL);
         glCullFace(GL_BACK);
         glEnable(GL_CULL_FACE);
         glFrontFace(GL_CCW);
         glClearColor(FbackR, FBackG, FbackB, 1.0);
{         glEnable(GL_NORMALIZE);}
    end;
end;


procedure TGMPCutdown.CalcNormal(var P1, P2, P3, Normal1 : TPoint3D);
var
   a,b : array [0..2] of Single;
   length : double;
   normal : TPoint3D;
begin
     a[0] := (P2.X - P1.X);
     a[1] := (P2.Y - P1.Y);
     a[2] := (P2.Z - P1.Z);
     b[0] := (P3.X - P1.X);
     b[1] := (P3.Y - P1.Y);
     b[2] := (P3.Z - P1.Z);


     normal1.X := (a[1] * b[2]) - (a[2] * b[1]);
     normal1.Y := (a[2] * b[0]) - (a[0] * b[2]);
     normal1.Z := (a[0] * b[1]) - (a[1] * b[0]);

     length := sqrt((normal1.X * normal1.X) + (normal1.Y * normal1.Y) + (normal1.Z * normal1.Z));
     if length <> 0 then
     begin
          normal1.X := normal1.X / length;
          normal1.Y := normal1.Y / length;
          normal1.Z := normal1.Z / length;
     end;


end;

procedure TGMPCutdown.SetLight(Enabled : Boolean; var Position : TPos4; var Ambient, Diffuse, Specular : TColor4);
begin
         wglmakeCurrent(MyHDC, MYHGC);

     Lights[0].Ambient := Ambient;
     Lights[0].Diffuse := Diffuse;
     Lights[0].Specular := Specular;
     Lights[0].Enabled := Enabled;
     Lights[0].Position.X := Position.X;
     Lights[0].Position.Y := Position.Y;
     Lights[0].Position.Z := Position.Z;
     Lights[0].Position.W := Position.W;
     If Lights[0].Enabled = True then
     begin
             ClearModelMatrix;
             glLightfv(GL_LIGHT0, GL_AMBIENT, @Ambient);
             glLightfv(GL_LIGHT0, GL_Diffuse, @Diffuse);
             glLightfv(GL_LIGHT0, GL_Specular, @Specular);
             glLightfv(GL_LIGHT0, GL_POSITION, @Position);
             glEnable(GL_Light0);
     end;
     If Lights[0].Enabled = False then
     begin
          glDisable(GL_Light0);
     end;

end;


procedure TGMPCutdown.SetPosition(X,Y,Z : Single);
begin
         wglmakeCurrent(MyHDC, MYHGC);

     glTranslatef(X,Y,Z);
end;

procedure TGMPCutdown.SetRotation(X,Y,Z, Angle : Single);
begin
         wglmakeCurrent(MyHDC, MYHGC);

    glRotatef(Angle, X, Y, Z);
end;

procedure TGMPCutdown.ClearModelMatrix;
begin
         wglmakeCurrent(MyHDC, MYHGC);

     glMatrixMode(GL_MODELVIEW);
     glLoadIdentity;
end;

procedure TGMPCutdown.ClearBuffer;
begin
         wglmakeCurrent(MyHDC, MYHGC);

     glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);

end;


procedure TGMPCutdown.SetViewPort(Left, Bottom, Width, Height : Integer);
var
Aspect : Single;
begin
     glViewPort(Left,Bottom, Width, Height );
     MyLeft := Left;
     MyWidth := Width;
     MyHeight := Height;
     MyBottom := Bottom;
     glMatrixMode(GL_PROJECTION);
     glLoadIdentity;
     Aspect := (MyWidth) / (MyHeight);
     gluPerspective(65, Aspect, 1.0, 500.0);

end;
procedure TGMPCutdown.SetCamera(var Position, Rotation : TPoint3D);
var
aspect : single;
begin
     glMatrixMode(GL_Projection);
     glLoadIdentity;
     Aspect := (MyWidth) / (MyHeight);
     gluPerspective(65, Aspect, 1.0, 500.0);

     glRotatef(Rotation.X,1,0,0);
     glRotatef(Rotation.Y,0,1,0);
     glRotatef(Rotation.Z,0,0,1);
     glTranslatef(Position.X, Position.Y, Position.Z);
end;

procedure TGMPCutdown.SetSwapBuffer(SwapIt : BOOLEAN);
begin
     FFlush := False;
     SwapBackBuffer;
end;

procedure TGMPCutdown.SwapBackBuffer;
begin
     glFlush;
     SwapBuffers(MyHDC);
end;
procedure TGMPCutdown.SetBackR(BackR : Single);
begin
     FBackR := BackR;
     glClearColor(FbackR, FBackG, FbackB, 1.0);
     glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
end;

procedure TGMPCutdown.SetBackG(BackG : Single);
begin
     FBackG := BackG;
     glClearColor(FbackR, FBackG, FbackB, 1.0);
     glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
end;

procedure TGMPCutdown.SetBackB(BackB : Single);
begin

     FBackB := BackB;
     glClearColor(FbackR, FBackG, FbackB, 1.0);
     glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
end;

destructor TGMPCutdown.Destroy;
begin
     inherited Destroy;
     wglDeleteContext(MyHGC);
     DeleteDC(MyHDC);

end;

constructor TGMPCutdown.Create(AOwner : TComponent);
begin
    inherited Create(AOwner);
   { ShowMessage('This is an Unregistered Version of TGMP.  Register it now to receive the full power of TGMP');}
    F3dRunning := False;
    MyHDC := GetDC(TForm(AOwner).Handle);
    GMPGold.Name := 'Gold';
    GMPGold.Specular.r := 1;
    GMPGold.Specular.g := 1;
    GMPGold.Specular.b := 1;
    GMPGold.Specular.a := 1;

    GMPGold.Ambient.r := 0.5;
    GMPGold.Ambient.g := 0.5;
    GMPGold.Ambient.b := 0;
    GMPGold.Ambient.a := 1;

    GMPGold.Diffuse.r := 0.6;
    GMPGold.Diffuse.g := 0.6;
    GMPGold.Diffuse.b := 0.0;
    GMPGold.Diffuse.a := 1;

    GMPGold.Shininess := 10;

    GMPGold.Emitted.r := 0.1;
    GMPGold.Emitted.g := 0.1;
    GMPGold.Emitted.b := 0;
    GMPGold.Emitted.a := 1;

    GMPSilver.Name := 'Silver';
    GMPSilver.Specular.r := 1;
    GMPSilver.Specular.g := 1;
    GMPSilver.Specular.b := 1;
    GMPSilver.Specular.a := 1;

    GMPSilver.Ambient.r := 0.4;
    GMPSilver.Ambient.g := 0.4;
    GMPSilver.Ambient.b := 0.4;
    GMPSilver.Ambient.a := 1;

    GMPSilver.Diffuse.r := 0.8;
    GMPSilver.Diffuse.g := 0.8;
    GMPSilver.Diffuse.b := 0.8;
    GMPSilver.Diffuse.a := 1;

    GMPSilver.Shininess := 20;

    GMPSilver.Emitted.r := 0.1;
    GMPSilver.Emitted.g := 0.15;
    GMPSilver.Emitted.b := 0.1;
    GMPSilver.Emitted.a := 1;

    GMPEbony.Name := 'Ebony';
    GMPEbony.Specular.r := 1;
    GMPEbony.Specular.g := 1;
    GMPEbony.Specular.b := 1;
    GMPEbony.Specular.a := 1;

    GMPEbony.Ambient.r := 0;
    GMPEbony.Ambient.g := 0;
    GMPEbony.Ambient.b := 0;
    GMPEbony.Ambient.a := 1;

    GMPEbony.Diffuse.r := 0.0;
    GMPEbony.Diffuse.g := 0.0;
    GMPEbony.Diffuse.b := 0.0;
    GMPEbony.Diffuse.a := 1;

    GMPEbony.Shininess := 10;

    GMPEbony.Emitted.r := 0.0;
    GMPEbony.Emitted.g := 0.0;
    GMPEbony.Emitted.b := 0.0;
    GMPEbony.Emitted.a := 1;

    GMPShinyBrass.Name := 'ShinyBrass';
    GMPShinyBrass.Specular.r := 1;
    GMPShinyBrass.Specular.g := 1;
    GMPShinyBrass.Specular.b := 1;
    GMPShinyBrass.Specular.a := 1;

    GMPShinyBrass.Ambient.r := 0.5;
    GMPShinyBrass.Ambient.g := 0.21;
    GMPShinyBrass.Ambient.b := 0.06;
    GMPShinyBrass.Ambient.a := 1;

    GMPShinyBrass.Diffuse.r := 1;
    GMPShinyBrass.Diffuse.g := 0.5;
    GMPShinyBrass.Diffuse.b := 0.3;
    GMPShinyBrass.Diffuse.a := 1;

    GMPShinyBrass.Shininess := 60;

    GMPShinyBrass.Emitted.r := 0.08;
    GMPShinyBrass.Emitted.g := 0.03;
    GMPShinyBrass.Emitted.b := 0.01;
    GMPShinyBrass.Emitted.a := 1;

    GMPPewter.Name := 'Pewter';
    GMPPewter.Specular.r := 1;
    GMPPewter.Specular.g := 1;
    GMPPewter.Specular.b := 1;
    GMPPewter.Specular.a := 1;

    GMPPewter.Ambient.r := 0.5;
    GMPPewter.Ambient.g := 0.5;
    GMPPewter.Ambient.b := 0.5;
    GMPPewter.Ambient.a := 1;

    GMPPewter.Diffuse.r := 0.5;
    GMPPewter.Diffuse.g := 0.5;
    GMPPewter.Diffuse.b := 0.7;
    GMPPewter.Diffuse.a := 1;

    GMPPewter.Shininess := 70;

    GMPPewter.Emitted.r := 0.07;
    GMPPewter.Emitted.g := 0.07;
    GMPPewter.Emitted.b := 0.07;
    GMPPewter.Emitted.a := 1;

    GMPChalk.Name := 'Chalk';
    GMPChalk.Specular.r := 0;
    GMPChalk.Specular.g := 0;
    GMPChalk.Specular.b := 0;
    GMPChalk.Specular.a := 1;

    GMPChalk.Ambient.r := 0.1;
    GMPChalk.Ambient.g := 0.1;
    GMPChalk.Ambient.b := 0.1;
    GMPChalk.Ambient.a := 1;

    GMPChalk.Diffuse.r := 0.75;
    GMPChalk.Diffuse.g := 0.75;
    GMPChalk.Diffuse.b := 0.75;
    GMPChalk.Diffuse.a := 1;

    GMPChalk.Shininess := 128;

    GMPChalk.Emitted.r := 0.1;
    GMPChalk.Emitted.g := 0.1;
    GMPChalk.Emitted.b := 0.1;
    GMPChalk.Emitted.a := 1;

    GMPBluePlastic.Name := 'BluePlastic';
    GMPBluePlastic.Specular.r := 1;
    GMPBluePlastic.Specular.g := 1;
    GMPBluePlastic.Specular.b := 1;
    GMPBluePlastic.Specular.a := 1;

    GMPBluePlastic.Ambient.r := 0.1;
    GMPBluePlastic.Ambient.g := 0.1;
    GMPBluePlastic.Ambient.b := 0.5;
    GMPBluePlastic.Ambient.a := 1;

    GMPBluePlastic.Diffuse.r := 1;
    GMPBluePlastic.Diffuse.g := 1;
    GMPBluePlastic.Diffuse.b := 1;
    GMPBluePlastic.Diffuse.a := 1;

    GMPBluePlastic.Shininess := 60;

    GMPBluePlastic.Emitted.r := 0.05;
    GMPBluePlastic.Emitted.g := 0.05;
    GMPBluePlastic.Emitted.b := 0.17;
    GMPBluePlastic.Emitted.a := 1;

    GMPBlackRubber.Name := 'BlackRubber';
    GMPBlackRubber.Specular.r := 0.4;
    GMPBlackRubber.Specular.g := 0.4;
    GMPBlackRubber.Specular.b := 0.4;
    GMPBlackRubber.Specular.a := 1;

    GMPBlackRubber.Ambient.r := 0.02;
    GMPBlackRubber.Ambient.g := 0.02;
    GMPBlackRubber.Ambient.b := 0.02;
    GMPBlackRubber.Ambient.a := 1;

    GMPBlackRubber.Diffuse.r := 0.01;
    GMPBlackRubber.Diffuse.g := 0.01;
    GMPBlackRubber.Diffuse.b := 0.01;
    GMPBlackRubber.Diffuse.a := 1;

    GMPBlackRubber.Shininess := 0.078125 * 128;

    GMPBlackRubber.Emitted.r := 0.0;
    GMPBlackRubber.Emitted.g := 0.0;
    GMPBlackRubber.Emitted.b := 0.0;
    GMPBlackRubber.Emitted.a := 1;

    GMPEmerald.Name := 'Emerald';
    GMPEmerald.Specular.r := 0.633;
    GMPEmerald.Specular.g := 0.727811;
    GMPEmerald.Specular.b := 0.633;
    GMPEmerald.Specular.a := 1;

    GMPEmerald.Ambient.r := 0.0215;
    GMPEmerald.Ambient.g := 0.17545;
    GMPEmerald.Ambient.b := 0.0215;
    GMPEmerald.Ambient.a := 1;

    GMPEmerald.Diffuse.r := 0.07568;
    GMPEmerald.Diffuse.g := 0.61424;
    GMPEmerald.Diffuse.b := 0.07568;
    GMPEmerald.Diffuse.a := 1;

    GMPEmerald.Shininess := 0.1 * 128;

    GMPEmerald.Emitted.r := 0.0;
    GMPEmerald.Emitted.g := 0.0;
    GMPEmerald.Emitted.b := 0.0;
    GMPEmerald.Emitted.a := 1;


    GMPDarkGreen.Name := 'DarkGreen';
    GMPDarkGreen.Specular.r := 0.633;
    GMPDarkGreen.Specular.g := 0.727811;
    GMPDarkGreen.Specular.b := 0.633;
    GMPDarkGreen.Specular.a := 1;

    GMPDarkGreen.Ambient.r := 0.0115;
    GMPDarkGreen.Ambient.g := 0.08545;
    GMPDarkGreen.Ambient.b := 0.0115;
    GMPDarkGreen.Ambient.a := 1;

    GMPDarkGreen.Diffuse.r := 0.03568;
    GMPDarkGreen.Diffuse.g := 0.31424;
    GMPDarkGreen.Diffuse.b := 0.03568;
    GMPDarkGreen.Diffuse.a := 1;

    GMPDarkGreen.Shininess := 0.1 * 128;

    GMPDarkGreen.Emitted.r := 0.0;
    GMPDarkGreen.Emitted.g := 0.0;
    GMPDarkGreen.Emitted.b := 0.0;
    GMPDarkGreen.Emitted.a := 1;

    GMPRuby.Name := 'Ruby';
    GMPRuby.Specular.r := 0.727811;
    GMPRuby.Specular.g := 0.626959;
    GMPRuby.Specular.b := 0.626959;
    GMPRuby.Specular.a := 1;

    GMPRuby.Ambient.r := 0.1745;
    GMPRuby.Ambient.g := 0.01175;
    GMPRuby.Ambient.b := 0.01175;
    GMPRuby.Ambient.a := 1;

    GMPRuby.Diffuse.r := 0.61424;
    GMPRuby.Diffuse.g := 0.04136;
    GMPRuby.Diffuse.b := 0.04136;
    GMPRuby.Diffuse.a := 1;

    GMPRuby.Shininess := 0.6 *128;

    GMPRuby.Emitted.r := 0.0;
    GMPRuby.Emitted.g := 0.0;
    GMPRuby.Emitted.b := 0.0;
    GMPRuby.Emitted.a := 1;

    GMPWoodBrown.Name := 'WoodBrown';
    GMPWoodBrown.Specular.r := 0.5;
    GMPWoodBrown.Specular.g := 0.5;
    GMPWoodBrown.Specular.b := 0.5;
    GMPWoodBrown.Specular.a := 1;

    GMPWoodBrown.Ambient.r := 0.15;
    GMPWoodBrown.Ambient.g := 0.07;
    GMPWoodBrown.Ambient.b := 0;
    GMPWoodBrown.Ambient.a := 1;

    GMPWoodBrown.Diffuse.r := 0.15;
    GMPWoodBrown.Diffuse.g := 0.09;
    GMPWoodBrown.Diffuse.b := 0;
    GMPWoodBrown.Diffuse.a := 1;

    GMPWoodBrown.Shininess := 60;

    GMPWoodBrown.Emitted.r := 0.0;
    GMPWoodBrown.Emitted.g := 0.0;
    GMPWoodBrown.Emitted.b := 0.0;
    GMPWoodBrown.Emitted.a := 1;


    GMPLightBrown.Name := 'LightBrown';
    GMPLightBrown.Specular.r := 0.5;
    GMPLightBrown.Specular.g := 0.5;
    GMPLightBrown.Specular.b := 0.5;
    GMPLightBrown.Specular.a := 1;

    GMPLightBrown.Ambient.r := 0.8;
    GMPLightBrown.Ambient.g := 0.5;
    GMPLightBrown.Ambient.b := 0;
    GMPLightBrown.Ambient.a := 1;

    GMPLightBrown.Diffuse.r := 0.8;
    GMPLightBrown.Diffuse.g := 0.5;
    GMPLightBrown.Diffuse.b := 0;
    GMPLightBrown.Diffuse.a := 1;

    GMPLightBrown.Shininess := 60;

    GMPLightBrown.Emitted.r := 0.0;
    GMPLightBrown.Emitted.g := 0.0;
    GMPLightBrown.Emitted.b := 0.0;
    GMPLightBrown.Emitted.a := 1;



end;

procedure Register;
begin
  RegisterComponents('Trial', [TGMPCutdown]);

end;


end.
